
Global RadDivider:Float = Pi / 180.0

Function Degrees:Float (radian:Float)
	Return radian * RadDivider
End

Function DrawCross:Void (canvas:Canvas, x:Float, y:Float, size:Float = 9.0)
	canvas.DrawLine (x - size * 0.5, y, x + size * 0.5, y)
	canvas.DrawLine (x, y - size * 0.5, x, y + size * 0.5)
End

Function FindFirstXboxPad:Joystick ()

	' Try find an Xbox gamepad, use first one found...
	
	Local j:Joystick
	
	For Local loop:Int = 0 Until Joystick.NumJoysticks ()

		j = Joystick.Open (loop)

		If j

			If Not j.Name.StartsWith ("XInput Controller #")
				j.Close ()
				j = Null
			Else
				Exit ' Found one!
			Endif

		Endif
		
	Next

	Return j
	
End

Function ValidateJoystick:Joystick (j:Joystick)

	If Not j Or Not j.Attached
		j = FindFirstXboxPad ()
	Endif
	
	Return j
	
End

Function PixmapFormat:String (pixmap:Pixmap)

	Select pixmap.Format
		Case PixelFormat.Unknown
			Return "PixelFormat.Unknown"
		Case PixelFormat.Depth16
			Return "PixelFormat.Depth16"
		Case PixelFormat.Depth24
			Return "PixelFormat.Depth24"
		Case PixelFormat.Depth32
			Return "PixelFormat.Depth32"
		Case PixelFormat.IA16
			Return "PixelFormat.IA16"
		Case PixelFormat.RGB24
			Return "PixelFormat.RGB24"
		Case PixelFormat.RGBA32F
			Return "PixelFormat.RGBA32F"
		Case PixelFormat.RGBA16F
			Return "PixelFormat.RGBA16F"
		Case PixelFormat.I8
			Return "PixelFormat.I8"
		Case PixelFormat.A8
			Return "PixelFormat.A8"
		Case PixelFormat.IA8
			Return "PixelFormat.IA8"
		Case PixelFormat.RGB8
			Return "PixelFormat.RGB8"
		Case PixelFormat.RGBA8
			Return "PixelFormat.RGBA8"
		Case PixelFormat.RGBA32
			Return "PixelFormat.RGBA32"
	End

	Return ""

End

Function ShadowText:Void (canvas:Canvas, s:String, x:Float, y:Float, fore:Color = Null, back:Color = Null)
	If Not fore Then fore = Color.White
	If Not back Then back = Color.Black
	canvas.Color = back
	canvas.DrawText	(s, x + 1, y + 1)
	canvas.Color = fore
	canvas.DrawText	(s, x, y)
End

Function Run3D (title:String, width:Int, height:Int, flags:WindowFlags = WindowFlags.Center)


	New AppInstance

	If Not width Or Not height
		width	= App.DesktopSize.X
		height	= App.DesktopSize.Y
	Endif
	
	New Game (title, width, height, flags)

	App.Run ()

End

Function CheckerPixmap:Pixmap (color0:Color, color1:Color)

	Local pixels:Pixmap = New Pixmap (256, 256, PixelFormat.RGBA8)
	pixels.Clear (color0)
	
	Local pixel_toggle:Int = 0
	
	For Local gp_y:Int = 0 Until pixels.Height
		For Local gp_x:Int = 0 Until pixels.Width
			If pixel_toggle Then pixels.SetPixel (gp_x, gp_y, color1)
			pixel_toggle = 1 - pixel_toggle
		Next
		pixel_toggle = 1 - pixel_toggle
	Next
	
	Return pixels
	
End